﻿using System.Collections.Generic;
using System.Linq;
using System.Web.Mvc;
using HIPS.Web.Model.AssistedRegistration;

namespace HIPS.Web.UI.Conversion.AssistedRegistration
{
    public static class RegisterViewModelExtensions
    {




        /// <summary>
        /// Returns Medicare Consent options in an ordered nested parent/child format up to one level of depth.
        /// Each Key represents a top-level Medicare Option, which may have zero or more nested child elements in the Value list.
        /// Nesting is only supported for one level of depth (children of children will be ignored).
        /// </summary>
        /// <returns>Medicare Consent options where each Key is a top-level option, 
        /// with the Value list representing zero or more nested child options</returns>
        internal static List<KeyValuePair<SelectListItem, List<SelectListItem>>> ToNestedSelectList(this List<MedicareConsent> consents)
        {
            // Group and Order
            List<KeyValuePair<MedicareConsent, List<MedicareConsent>>> nestedConsents = 
                consents.Where(c => c.ParentMedicareConsentId == null)
                .ToDictionary(
                    c => c,
                    c => consents
                        .Where(ic => ic.ParentMedicareConsentId == c.MedicareConsentId)
                        .OrderBy(ic => ic.DisplayOrder).ToList())
                .OrderBy(c => c.Key.DisplayOrder)
                .ToList();

            // Convert to SelectListItems
            return nestedConsents.Select(m => 
                new KeyValuePair<SelectListItem, List<SelectListItem>>
                    (new SelectListItem() { Text = m.Key.Description, Value = m.Key.Code },
                    m.Value.Select(mi => new SelectListItem() { Text = mi.Description, Value = mi.Code }).ToList()))
                    .ToList();
        }
    }
}